
<?php
header('Content-Type: application/json');
require_once '../../config/db.php';

// Log script version
error_log("Using get_schedules.php version: x0s1t2u3-9v0w-5x6y-1z2a-3b4c5d6e7f8");

// Define timestamp for logging
$timestamp = date('Y-m-d H:i:s');

// Ensure logs directory exists
$log_dir = '../logs';
$log_file = "$log_dir/schedules_debug.txt";
if (!is_dir($log_dir)) {
    mkdir($log_dir, 0755, true);
}

// Get parameters
$start = $_GET['start'] ?? date('Y-m-d', strtotime('-1 month'));
$end = $_GET['end'] ?? date('Y-m-d', strtotime('+1 month'));
$branch_id = (int)($_GET['branch_id'] ?? 0);

// Log request
$request_log = "[$timestamp] Request: start=$start, end=$end, branch_id=$branch_id";
error_log($request_log);
file_put_contents($log_file, "$request_log\n", FILE_APPEND);

$events = [];
try {
    $query = "
        SELECT s.staff_id, s.first_name, s.last_name, sch.schedule_date, sch.shift_type
        FROM staff s
        LEFT JOIN schedules sch ON s.staff_id = sch.staff_id
        WHERE sch.schedule_date BETWEEN ? AND ?
        AND (? = 0 OR s.branch_id = ?)
        AND sch.schedule_date IS NOT NULL
    ";
    $stmt = $conn->prepare($query);
    if (!$stmt) {
        throw new Exception('Prepare failed: ' . $conn->error);
    }
    $stmt->bind_param('ssii', $start, $end, $branch_id, $branch_id);
    $stmt->execute();
    $result = $stmt->get_result();

    while ($row = $result->fetch_assoc()) {
        $events[] = [
            'title' => $row['first_name'] . ' ' . $row['last_name'],
            'start' => $row['schedule_date'],
            'extendedProps' => [
                'shift_type' => $row['shift_type']
            ],
            'backgroundColor' => $row['shift_type'] === 'off' ? '#ff0000' : '#3788d8',
            'borderColor' => $row['shift_type'] === 'off' ? '#ff0000' : '#3788d8'
        ];
    }

    // Log event count
    $event_log = "[$timestamp] Returned " . count($events) . " events";
    error_log($event_log);
    file_put_contents($log_file, "$event_log\n", FILE_APPEND);
} catch (Exception $e) {
    $error_log = "[$timestamp] Fetch schedules failed: " . $e->getMessage();
    error_log($error_log);
    file_put_contents($log_file, "$error_log\n", FILE_APPEND);
    http_response_code(500);
    echo json_encode(['error' => 'Failed to fetch schedules: ' . $e->getMessage()]);
    exit;
}

// Close connection
$conn->close();

echo json_encode($events);