<?php
session_start();
require_once '../../config/db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['photo'])) {
    $staff_id = (int)($_POST['id'] ?? 0);
    $national_id = preg_replace("/[^0-9]/", "", $_POST['national_id'] ?? '');

    if (!$staff_id || !$national_id) {
        $_SESSION['error'] = 'Missing staff ID or National ID.';
        header("Location: edit.php?id=$staff_id");
        exit;
    }

    $uploadDir = '../../uploads/staff_photos/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }

    $tmpFile = $_FILES['photo']['tmp_name'];
    $ext = strtolower(pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION));
    $allowed = ['jpg', 'jpeg', 'png'];

    if (!in_array($ext, $allowed)) {
        $_SESSION['error'] = "Only JPG, PNG, JPEG files allowed.";
        header("Location: edit.php?id=$staff_id");
        exit;
    }

    $newFileName = "nid_{$national_id}." . $ext;
    $destination = $uploadDir . $newFileName;

    if (move_uploaded_file($tmpFile, $destination)) {
        $stmt = $conn->prepare("UPDATE staff SET photo = ? WHERE id = ?");
        $stmt->bind_param("si", $newFileName, $staff_id);
        $stmt->execute();
        $stmt->close();

        $_SESSION['success'] = "Photo uploaded successfully.";
    } else {
        $_SESSION['error'] = "Failed to upload photo.";
    }

    header("Location: edit.php?id=$staff_id");
    exit;
}
?>
