<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

if (empty($_SESSION['csrf_token'])) {
  $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>

<div class="main-content">
  <h4 class="fw-bold mb-4 text-primary"><i class="fas fa-truck"></i> Add New Supplier</h4>

  <form action="save_supplier.php" method="POST" class="card shadow-sm p-4 bg-white">
    <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">

    <div class="row mb-3">
      <div class="col-md-6">
        <label class="form-label">Supplier Name</label>
        <input type="text" name="name" class="form-control" required>
      </div>

      <div class="col-md-6">
        <label class="form-label">KRA PIN</label>
        <input type="text" name="kra_pin" class="form-control" required>
      </div>
    </div>

    <div class="row mb-3">
      <div class="col-md-4">
        <label class="form-label">Contact Person</label>
        <input type="text" name="contact_person" class="form-control">
      </div>

      <div class="col-md-4">
        <label class="form-label">Phone Number</label>
        <input type="text" name="phone" class="form-control">
      </div>

      <div class="col-md-4">
        <label class="form-label">Email Address</label>
        <input type="email" name="email" class="form-control">
      </div>
    </div>

    <div class="row mb-3">
      <div class="col-md-4">
        <label class="form-label">Bank Name</label>
        <input type="text" name="bank_name" class="form-control">
      </div>

      <div class="col-md-4">
        <label class="form-label">Branch</label>
        <input type="text" name="branch_name" class="form-control">
      </div>

      <div class="col-md-4">
        <label class="form-label">Account Number</label>
        <input type="text" name="account_no" class="form-control">
      </div>
    </div>

    <div class="row mb-3">
      <div class="col-md-6">
        <label class="form-label">Credit Days Allowed</label>
        <input type="number" name="credit_days" class="form-control" placeholder="e.g. 30">
      </div>

      <div class="col-md-6">
        <label class="form-label">Credit Limit (KSh)</label>
        <input type="number" step="0.01" name="credit_limit" class="form-control" placeholder="e.g. 100000">
      </div>
    </div>

    <div class="text-end">
      <button type="submit" class="btn btn-primary"><i class="fas fa-save me-1"></i> Save Supplier</button>
    </div>
  </form>
</div>
