<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

if (!isset($_GET['id'])) {
  $_SESSION['error'] = "Supplier not specified.";
  header("Location: list.php");
  exit;
}

$id = (int) $_GET['id'];
$stmt = $conn->prepare("SELECT * FROM suppliers WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
  $_SESSION['error'] = "Supplier not found.";
  header("Location: list.php");
  exit;
}

$s = $result->fetch_assoc();

// Optional: simulate roles (for demo/testing)
// $_SESSION['role'] = 'accountant'; // or 'admin'
$user_role = $_SESSION['role'] ?? 'viewer';
?>

<div class="main-content">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="fw-bold text-primary"><i class="fas fa-user-tie"></i> Supplier Profile</h4>
    <a href="list.php" class="btn btn-secondary btn-sm"><i class="fas fa-arrow-left me-1"></i> Back</a>
  </div>

  <div class="card shadow-sm p-4 bg-white mb-4">
    <div class="row mb-3">
      <div class="col-md-6">
        <strong>Name:</strong><br><?= htmlspecialchars($s['name']) ?>
      </div>
      <div class="col-md-6">
        <?php if ($user_role === 'admin' || $user_role === 'accountant'): ?>
          <strong>KRA PIN:</strong><br><?= htmlspecialchars($s['kra_pin']) ?>
        <?php else: ?>
          <strong>KRA PIN:</strong><br><span class="text-muted">Hidden</span>
        <?php endif; ?>
      </div>
    </div>

    <div class="row mb-3">
      <div class="col-md-4">
        <strong>Contact Person:</strong><br><?= htmlspecialchars($s['contact_person']) ?>
      </div>
      <div class="col-md-4">
        <strong>Phone:</strong><br><?= htmlspecialchars($s['phone']) ?>
      </div>
      <div class="col-md-4">
        <strong>Email:</strong><br><?= htmlspecialchars($s['email']) ?>
      </div>
    </div>

    <div class="row mb-3">
      <div class="col-md-4">
        <strong>Bank Name:</strong><br>
        <?= ($user_role === 'admin' || $user_role === 'accountant') ? htmlspecialchars($s['bank_name']) : '<span class="text-muted">Hidden</span>' ?>
      </div>
      <div class="col-md-4">
        <strong>Branch:</strong><br>
        <?= ($user_role === 'admin' || $user_role === 'accountant') ? htmlspecialchars($s['branch_name']) : '<span class="text-muted">Hidden</span>' ?>
      </div>
      <div class="col-md-4">
        <strong>Account No:</strong><br>
        <?= ($user_role === 'admin' || $user_role === 'accountant') ? htmlspecialchars($s['account_no']) : '<span class="text-muted">Hidden</span>' ?>
      </div>
    </div>

    <div class="row">
      <div class="col-md-6">
        <strong>Credit Days Allowed:</strong><br><?= $s['credit_days'] ?> days
      </div>
      <div class="col-md-6">
        <strong>Credit Limit:</strong><br>KSh <?= number_format($s['credit_limit'], 2) ?>
      </div>
    </div>
  </div>

  <!-- 📄 Additional Supplier Sections -->
  <div class="card shadow-sm p-4 bg-white">
    <h5 class="fw-bold mb-3"><i class="fas fa-link"></i> Related Data</h5>

    <ul class="list-group list-group-flush">
      <li class="list-group-item">
        <a href="/smartpay360/modules/invoices/list.php?supplier_id=<?= $s['id'] ?>">
          <i class="fas fa-file-invoice me-1"></i> View Supplier Invoices
        </a>
      </li>
      <li class="list-group-item">
        <a href="/smartpay360/modules/payments/list.php?supplier_id=<?= $s['id'] ?>">
          <i class="fas fa-money-check me-1"></i> View Payments to Supplier
        </a>
      </li>
      <li class="list-group-item">
        <a href="/smartpay360/modules/reports/statement.php?supplier_id=<?= $s['id'] ?>" target="_blank">
          <i class="fas fa-file-pdf me-1"></i> Download Statement PDF
        </a>
      </li>
    </ul>
  </div>
</div>
