<?php
// Enable debugging in development
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
require_once '../../config/db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: ../../login.php");
    exit;
}

// Validate ID
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header("Location: manage_cashiers.php?error=Invalid cashier ID");
    exit;
}

$id = (int) $_GET['id'];

// Handle Update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name']);
    $status = strtolower($_POST['status'] ?? 'active');

    if (!empty($name)) {
        $stmt = $conn->prepare("UPDATE cashiers SET name = ?, status = ? WHERE id = ?");
        $stmt->bind_param("ssi", $name, $status, $id);
        if ($stmt->execute()) {
            header("Location: manage_cashiers.php?success=Cashier updated");
            exit;
        } else {
            $error = "Update failed: " . $stmt->error;
        }
    } else {
        $error = "Cashier name is required.";
    }
}

// Fetch cashier details
$stmt = $conn->prepare("SELECT * FROM cashiers WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$cashier = $result->fetch_assoc();

if (!$cashier) {
    header("Location: manage_cashiers.php?error=Cashier not found");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Edit Cashier</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body>
<div class="container mt-5 mb-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="fw-bold text-primary">✏️ Edit Cashier</h4>
    <a href="manage_cashiers.php" class="btn btn-outline-secondary btn-sm">← Back to Cashiers</a>
  </div>

  <?php if (isset($error)): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
      <?= htmlspecialchars($error) ?>
      <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
  <?php endif; ?>

  <form method="POST" class="row g-3">
    <div class="col-md-6">
      <label class="form-label">Cashier Name</label>
      <input type="text" name="name" value="<?= htmlspecialchars($cashier['name']) ?>" class="form-control" required>
    </div>
    <div class="col-md-3">
      <label class="form-label">Status</label>
      <select name="status" class="form-select">
        <option value="active" <?= $cashier['status'] === 'active' ? 'selected' : '' ?>>Active</option>
        <option value="inactive" <?= $cashier['status'] === 'inactive' ? 'selected' : '' ?>>Inactive</option>
      </select>
    </div>
    <div class="col-md-3 text-end mt-4">
      <button type="submit" class="btn btn-primary">💾 Update Cashier</button>
    </div>
  </form>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
