<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

$from = $_GET['from'] ?? date('Y-m-01');
$to = $_GET['to'] ?? date('Y-m-d');

$stmt = $conn->prepare("
    SELECT b.branch_name,
           COUNT(h.id) AS reports,
           SUM(d.note_1000 + d.note_500 + d.note_200 + d.note_100 + d.note_50 + d.coins + d.drop1 + d.drop2 + d.drop3) AS cash_total,
           SUM(d.mpesa + d.stk) AS mpesa_total,
           SUM(d.visa) AS visa_total,
           SUM(d.credit) AS credit_total,
           (SELECT IFNULL(SUM(amount),0) FROM till_report_cheques c WHERE c.report_id = d.report_id) AS cheques_total,
           SUM(d.mpesa + d.stk + d.visa + d.credit + d.note_1000 + d.note_500 + d.note_200 + d.note_100 + d.note_50 + d.coins + d.drop1 + d.drop2 + d.drop3) AS counted_total,
           SUM(d.declared_total) AS declared_total
    FROM till_report_headers h
    JOIN branches b ON b.id = h.branch_id
    JOIN till_report_details d ON d.report_id = h.id
    WHERE h.report_date BETWEEN ? AND ?
    GROUP BY b.branch_name
    ORDER BY b.branch_name
");
$stmt->bind_param("ss", $from, $to);
$stmt->execute();
$data = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

$sum_counted = $sum_declared = 0;
$branch_labels = $counted_data = $declared_data = [];

foreach ($data as $row) {
    $branch_labels[] = $row['branch_name'];
    $counted_data[] = round($row['counted_total'], 2);
    $declared_data[] = round($row['declared_total'], 2);
    $sum_counted += $row['counted_total'];
    $sum_declared += $row['declared_total'];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>📋 Director Summary - Till Reports</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <style>
    body { background: #f9fbfd; font-size: 14px; }
    .summary-box { background: #fff; border-left: 5px solid #007bff; padding: 20px; margin-bottom: 20px; box-shadow: 0 1px 3px rgba(0,0,0,0.05); border-radius: 8px; }
    .summary-box h5 { margin: 0 0 10px; font-weight: 600; }
    .summary-box small { color: #6c757d; }
    .variance-pos { color: green; font-weight: 500; }
    .variance-neg { color: red; font-weight: 500; }
    .chart-container { background: #fff; padding: 20px; border-radius: 10px; box-shadow: 0 0 6px rgba(0,0,0,0.05); margin-bottom: 25px; }
    .form-control-sm { max-width: 160px; }
    @media print { .no-print { display: none; } }
  </style>
</head>
<body>
<div class="container py-4">
  <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center mb-4">
    <h4 class="mb-3 mb-md-0">📊 Director Summary <small class="text-muted">(<?= $from ?> to <?= $to ?>)</small></h4>
    <form method="get" class="d-flex gap-2 no-print">
      <input type="date" name="from" value="<?= $from ?>" class="form-control form-control-sm">
      <input type="date" name="to" value="<?= $to ?>" class="form-control form-control-sm">
      <button class="btn btn-sm btn-primary">Filter</button>
    </form>
  </div>

  <!-- Line Chart -->
  <div class="chart-container">
    <canvas id="tillChart" height="100"></canvas>
  </div>

  <?php foreach ($data as $row): 
    $counted = $row['counted_total'];
    $declared = $row['declared_total'];
    $variance = $counted - $declared;
    $variance_class = $variance > 0 ? 'variance-pos' : ($variance < 0 ? 'variance-neg' : 'text-muted');
  ?>
    <div class="summary-box">
      <h5>🏢 <?= htmlspecialchars($row['branch_name']) ?> <span class="badge bg-secondary"><?= $row['reports'] ?> reports</span></h5>
      <div>💵 Counted: <strong>KES <?= number_format($counted, 2) ?></strong></div>
      <div>🧾 Declared: <strong>KES <?= number_format($declared, 2) ?></strong></div>
      <div>📉 Variance: <span class="<?= $variance_class ?>"><?= ($variance > 0 ? '+' : '') . 'KES ' . number_format($variance, 2) ?></span></div>
    </div>
  <?php endforeach; ?>

  <div class="summary-box border-start border-4 border-success">
    <h5>📋 GRAND TOTAL</h5>
    <div>💰 Total Counted: <strong>KES <?= number_format($sum_counted, 2) ?></strong></div>
    <div>🧾 Total Declared: <strong>KES <?= number_format($sum_declared, 2) ?></strong></div>
    <div>🧮 Net Over/Short: 
      <strong class="<?= ($sum_counted - $sum_declared) >= 0 ? 'variance-pos' : 'variance-neg' ?>">
        <?= ($sum_counted - $sum_declared > 0 ? '+' : '') . 'KES ' . number_format($sum_counted - $sum_declared, 2) ?>
      </strong>
    </div>
  </div>

  <div class="no-print mt-3 d-flex gap-2">
    <a href="list_reports.php" class="btn btn-outline-secondary btn-sm"><i class="fas fa-eye me-1"></i> Detailed Reports</a>
    <a href="#" onclick="window.print()" class="btn btn-dark btn-sm"><i class="fas fa-print me-1"></i> Print Summary</a>
  </div>
</div>

<script>
const ctx = document.getElementById('tillChart').getContext('2d');
const tillChart = new Chart(ctx, {
    type: 'line',
    data: {
        labels: <?= json_encode($branch_labels) ?>,
        datasets: [
            {
                label: 'Counted Total',
                data: <?= json_encode($counted_data) ?>,
                borderColor: 'rgba(40, 167, 69, 0.8)',
                fill: false,
                tension: 0.3
            },
            {
                label: 'Declared Total',
                data: <?= json_encode($declared_data) ?>,
                borderColor: 'rgba(0, 123, 255, 0.8)',
                fill: false,
                tension: 0.3
            }
        ]
    },
    options: {
        responsive: true,
        plugins: {
            legend: { position: 'bottom' }
        },
        scales: {
            y: { beginAtZero: false }
        }
    }
});
</script>

<script src="https://kit.fontawesome.com/a2d9d6b8d6.js" crossorigin="anonymous"></script>
</body>
</html>
