<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

ini_set('display_errors', 1);
error_reporting(E_ALL);

// Filters
$from = $_GET['from'] ?? '';
$to = $_GET['to'] ?? '';
$branch_filter = $_GET['branch'] ?? '';

// Fetch reports
$query = "SELECT h.id AS report_id, h.report_date, h.remarks, h.created_at, b.branch_name
          FROM till_report_headers h
          JOIN branches b ON b.id = h.branch_id
          WHERE 1=1";
$params = [];
$param_types = '';

if ($from && $to) {
  $query .= " AND h.report_date BETWEEN ? AND ?";
  $params[] = $from;
  $params[] = $to;
  $param_types .= 'ss';
}
if ($branch_filter) {
  $query .= " AND b.branch_name = ?";
  $params[] = $branch_filter;
  $param_types .= 's';
}
$query .= " ORDER BY h.report_date DESC, h.id DESC";

$stmt = $conn->prepare($query);
if (!$stmt) die("Query failed: " . $conn->error);
if ($params) $stmt->bind_param($param_types, ...$params);
$stmt->execute();
$report_results = $stmt->get_result();

// Build summaries
$reports = [];
$grand_total = 0;
$total_declared = 0;

while ($row = $report_results->fetch_assoc()) {
  $report_id = $row['report_id'];

  $details = $conn->query("SELECT * FROM till_report_details WHERE report_id = $report_id")->fetch_all(MYSQLI_ASSOC);
  $cash_total = $mpesa_total = $visa_total = $declared_total = 0;

  foreach ($details as $d) {
    $tt_notes = $d['note_1000'] + $d['note_500'] + $d['note_200'] + $d['note_100'] + $d['note_50'];
    $drop = $d['drop1'] + $d['drop2'] + $d['drop3'];
    $cash = $tt_notes + $drop + $d['coins'];
    $cash_total += $cash;
    $mpesa_total += $d['mpesa'];
    $visa_total += $d['visa'];
    $declared_total += $d['declared_total'];
  }

  $cheque_query = $conn->query("SELECT SUM(amount) AS total_cheques FROM till_report_cheques WHERE report_id = $report_id");
  $cheque_row = $cheque_query->fetch_assoc();
  $cheque_total = floatval($cheque_row['total_cheques'] ?? 0);

  $total = $cash_total + $mpesa_total + $visa_total + $cheque_total;
  $net_variance = $declared_total - $total;

  $grand_total += $total;
  $total_declared += $declared_total;

  $reports[] = [
    'report_id' => $report_id,
    'branch_name' => $row['branch_name'],
    'report_date' => $row['report_date'],
    'cash' => $cash_total,
    'mpesa' => $mpesa_total,
    'visa' => $visa_total,
    'cheques' => $cheque_total,
    'total' => $total,
    'declared' => $declared_total,
    'variance' => $net_variance,
    'remarks' => $row['remarks'],
    'created_at' => $row['created_at']
  ];
}

// Branch options
$branches = $conn->query("SELECT DISTINCT branch_name FROM branches ORDER BY branch_name")->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>All Till Reports</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css" rel="stylesheet">
  <link href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.bootstrap5.min.css" rel="stylesheet">
</head>
<body>
<div class="container my-4">
  <div class="bg-primary text-white p-3 rounded mb-4 text-center">
    <h4 class="m-0">📊 Till Report List</h4>
  </div>

  <?php if (isset($_GET['success'])): ?>
    <div class="alert alert-success"><?= htmlspecialchars($_GET['success']) ?></div>
  <?php endif; ?>
  <?php if (isset($_GET['error'])): ?>
    <div class="alert alert-danger"><?= htmlspecialchars($_GET['error']) ?></div>
  <?php endif; ?>

  <form method="GET" class="row g-2 mb-3">
    <div class="col-md-3">
      <label class="form-label">From</label>
      <input type="date" name="from" value="<?= htmlspecialchars($from) ?>" class="form-control">
    </div>
    <div class="col-md-3">
      <label class="form-label">To</label>
      <input type="date" name="to" value="<?= htmlspecialchars($to) ?>" class="form-control">
    </div>
    <div class="col-md-3">
      <label class="form-label">Branch</label>
      <select name="branch" class="form-select">
        <option value="">-- All Branches --</option>
        <?php foreach ($branches as $b): ?>
          <option value="<?= htmlspecialchars($b['branch_name']) ?>" <?= $branch_filter === $b['branch_name'] ? 'selected' : '' ?>>
            <?= htmlspecialchars($b['branch_name']) ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3 d-flex align-items-end">
      <button type="submit" class="btn btn-primary w-100">Filter</button>
    </div>
  </form>

  <div class="alert alert-info">
    <strong>💰 Total Reported:</strong> KES <?= number_format($grand_total, 2) ?> |
    <strong>🧾 Declared Total:</strong> KES <?= number_format($total_declared, 2) ?> |
    <strong>🔁 Net Over/Short:</strong> 
    <span class="<?= ($total_declared - $grand_total) < 0 ? 'text-danger' : 'text-success' ?>">
      KES <?= number_format($total_declared - $grand_total, 2) ?>
    </span>
  </div>

  <table id="reportTable" class="table table-bordered table-striped table-sm">
    <thead class="table-light">
      <tr>
        <th>Date</th>
        <th>Report ID</th>
        <th>Branch</th>
        <th>Cash</th>
        <th>MPESA</th>
        <th>VISA</th>
        <th>Cheques</th>
        <th>Total</th>
        <th>Declared</th>
        <th>Net ±</th>
        <th>Actions</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($reports as $r): ?>
        <tr>
          <td><?= htmlspecialchars($r['report_date']) ?></td>
          <td>#<?= $r['report_id'] ?></td>
          <td><?= htmlspecialchars($r['branch_name']) ?></td>
          <td>KES <?= number_format($r['cash'], 2) ?></td>
          <td>KES <?= number_format($r['mpesa'], 2) ?></td>
          <td>KES <?= number_format($r['visa'], 2) ?></td>
          <td>KES <?= number_format($r['cheques'], 2) ?></td>
          <td class="fw-bold text-success">KES <?= number_format($r['total'], 2) ?></td>
          <td>KES <?= number_format($r['declared'], 2) ?></td>
          <td class="<?= $r['variance'] < 0 ? 'text-danger' : 'text-success' ?>">
            <?= number_format($r['variance'], 2) ?>
          </td>
          <td>
            <a href="view_report.php?report_id=<?= $r['report_id'] ?>" class="btn btn-sm btn-primary">View</a>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>

  <div class="mt-3">
    <a href="cashier_report.php" class="btn btn-success btn-sm">+ Create New Till Report</a>
  </div>
</div>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>

<script>
$(document).ready(function () {
  $('#reportTable').DataTable({
    dom: 'Bfrtip',
    buttons: ['copy', 'excel', 'pdf', 'print'],
    pageLength: 10,
    order: [[0, 'desc']]
  });
});
</script>
</body>
</html>
