<?php
require_once __DIR__ . '/config/db.php';

$nid = $_GET['nid'] ?? '';
$nid = trim($nid);
error_log("DEBUG: Received NID = $nid");

if (!preg_match('/^\d+$/', $nid)) {
    http_response_code(400);
    echo "Invalid NID format: $nid";
    exit;
}

$photoDir = __DIR__ . '/uploads/staff_photos/';
$oldFilename = "nid_$nid.jpg";
$oldPath = $photoDir . $oldFilename;

if (!file_exists($oldPath)) {
    http_response_code(404);
    echo "File not found: $oldFilename";
    exit;
}

// Lookup staff
$stmt = $conn->prepare("SELECT staff_id FROM staff WHERE national_id = ?");
$stmt->bind_param('s', $nid);
$stmt->execute();
$row = $stmt->get_result()->fetch_assoc();

if (!$row) {
    http_response_code(404);
    echo "No staff found with national_id = $nid";
    exit;
}

$staff_id = $row['staff_id'];
$newFilename = "staff_" . $staff_id . ".jpg";
$newPath = $photoDir . $newFilename;

if (!rename($oldPath, $newPath)) {
    http_response_code(500);
    echo "Failed to rename $oldFilename";
    exit;
}

// Update DB
$update = $conn->prepare("UPDATE staff SET photo = ? WHERE staff_id = ?");
$update->bind_param('ss', $newFilename, $staff_id);
$update->execute();

echo "Renamed to $newFilename";
